#!/bin/sh
SERVER="server.example.com"
UPORT=1337

tmux set-option status-style fg=black,bg=cyan
tmux set-option status-left 'TESTSETUP: #{pane_title}'
tmux set-option status-left-length 20000
tmux set-option status-right '%Y-%m-%d %H:%M:%S'
tmux set-option status-format[0] "#[align=left range=left #{status-left-style}]#[push-default]#{T;=/#{status-left-length}:status-left}#[pop-default]#[norange default]#[list=on align=#{status-justify}]#[list=left-marker]<#[list=right-marker]>#[list=on]#[nolist align=right range=right #{status-right-style}]#[push-default]#{T;=/#{status-right-length}:status-right}#[pop-default]#[norange default]"
tmux set-option status-interval 1

send() {
    if [ "$MODE" != "local" ]; then
        rm data.zip > /dev/null 2>&1
        zip -r data.zip data/* > /dev/null 2>&1
        # Netcat-option -c breaks sending of files (problem occured with zip)
        # sometimes before the entire file is sent
        # Current solution is to define a timeout of 10s so the entire file is
        # sent
        cat data.zip | timeout --preserve-status 10s nc "$SERVER" $UPORT 2>/dev/null
        if [ $? -eq 0 ]; then
            echo "Successfully sent data to server."
        else
            echo "Unable to send data to server."
        fi
    fi
}

getPoCNameFromConfig() {
    echo "$(echo $1 | cut -d "_" -f 2-)"
}

Set_Step() {
    tmux select-pane -T "[$(printf %6.2f $PRC)%] $EXECMODE PoC $POCNAME ($FLIPPER)"
    PRC=$(echo "scale=3; $PRC + $StepPRC" | bc)
}


export MODE=$(cat /etc/mode.txt)

source Scripts/remoteConfig.sh

if [ "$MODE" == "local" ]; then
    mymac=$(ip addr | grep "link/ether" | head -n 1 | cut -d " " -f 6 | sed 's/://g')
    if ! [ -f /root/rowhammershare/local/${mymac}_module.txt ]; then
        echo "This device (identifier: ${mymac} is not known."
        echo "Please use the local input or SSH to one of the following IPs and complete the interaction:"
        echo -e "$(ip addr | grep "inet" | cut -d " " -f 6 | tail -n +3)\n"
        echo "What is the number of the DIMM currently in use: "
        read current_dimm
        echo "What is the step size (e.g. the difference between this and the next DIMM numbers): "
        read step_width
        echo "steps=$step_width" > /root/rowhammershare/local/${mymac}_module.txt
        echo "dimm=$current_dimm" >> /root/rowhammershare/local/${mymac}_module.txt
    fi
    export STEPS=$(cat /root/rowhammershare/local/${mymac}_module.txt | grep 'steps=' | cut -d "=" -f 2)
    export MODNUM=$(cat /root/rowhammershare/local/${mymac}_module.txt | grep 'dimm=' | cut -d "=" -f 2)
    export MODULE=$(printf "D4M%03d" $MODNUM)

    source Scripts/localConfig.sh
fi

flipper=$(ps -aux | grep "flipper" | wc -l)
if [ $flipper -ne 1 ]; then
    echo "Flipper is already running. It seems there is already an experiment in progress."
else
    rm -r data 2>/dev/null
    mkdir data

    CONFIGDIR="data/config"
    mkdir $CONFIGDIR

    source Scripts/collectInformation.sh
    source Scripts/reverseEngineerAddressFunctions.sh

    if [ "$?" != "0" ]; then
        # Reverse-engineering of address functions failed. Exit.
        exit 255
    fi

    source Scripts/experiments.sh
    source Scripts/evaluate.sh

fi

if [ "$MODE" == "local" ]; then
    mkdir /root/rowhammershare/local/${MODULE}_${mymac}
    cp -r data/* /root/rowhammershare/local/${MODULE}_${mymac}/
    echo "steps=$STEPS" > /root/rowhammershare/local/${mymac}_module.txt
    echo "dimm=$(expr $MODNUM + $STEPS)" >> /root/rowhammershare/local/${mymac}_module.txt
else
    if [ "$1" != "noauto" ]; then
        echo -e "\nSending results."
        send
    fi
fi

tmux select-pane -T "Done. Thank you for participating in our experiment."
