measure_init() {
    mkdir data/experiments

    TIMEOUT_SEC="$(expr $(echo $TIMEOUT | cut -d "h" -f 1) \* 3600)"
    DIMMS=$(dmidecode -t 17 | grep "Size" | grep -v "No Module Installed" | wc -l)

    MinPRC="1"
    MaxPRC="95"

    steps=0
    for i in "${!BASELINE@}"; do
        if [ "${!i}" == "Y" ]; then
            source "Scripts/PoCModules/$(getPoCNameFromConfig $i).sh"
            init_$(getPoCNameFromConfig $i)
            setvar_$(getPoCNameFromConfig $i)
            steps=$(expr $steps + $POCITERATIONS)
        fi
    done

    for i in "${!FLIPPER@}"; do
        if [ "${!i}" == "Y" ]; then
            source "Scripts/PoCModules/$(getPoCNameFromConfig $i).sh"
            init_$(getPoCNameFromConfig $i)
            setvar_$(getPoCNameFromConfig $i)
            steps=$(expr $steps + $POCITERATIONS)
        fi
    done

    StepPRC=$(echo "scale=3; ($MaxPRC - $MinPRC) / $steps"  | bc)
    PRC="$MinPRC"
}

measure_start_flipper() {
    echo -e "\nStarting Flipper..."
    chmod +x ./PoC/hammertool/flipper
    ./PoC/hammertool/flipper &
    sleep 30
}

measure_kill_flipper() {
    echo -e "\nKilling Flipper..."
    killall flipper
}

measure_init

EXECMODE="Executing"

FLIPPER="without FLIPPER"
LOGDIR="data/experiments/NoFlipper"
mkdir $LOGDIR
for i in "${!BASELINE@}"; do
    if [ "${!i}" == "Y" ]; then
        setvar_$(getPoCNameFromConfig $i)
        Set_Step
        measure_$(getPoCNameFromConfig $i)
    fi
done

measure_start_flipper

FLIPPER="with FLIPPER"
LOGDIR="data/experiments/Flipper"
mkdir $LOGDIR
for i in "${!FLIPPER@}"; do
    if [ "${!i}" == "Y" ]; then
        setvar_$(getPoCNameFromConfig $i)
        Set_Step
        measure_$(getPoCNameFromConfig $i)
    fi
done

measure_kill_flipper
