#!/bin/sh
eval_init() {
    mkdir data/results

    MinPRC="95"
    MaxPRC="100"

    steps=0
    for i in "${!BASELINE@}"; do
        if [ "${!i}" == "Y" ]; then
            source "Scripts/PoCModules/$(getPoCNameFromConfig $i).sh"
            setvar_$(getPoCNameFromConfig $i)
            steps=$(expr $steps + $POCITERATIONS)
        fi
    done

    for i in "${!FLIPPER@}"; do
        if [ "${!i}" == "Y" ]; then
            source "Scripts/PoCModules/$(getPoCNameFromConfig $i).sh"
            setvar_$(getPoCNameFromConfig $i)
            steps=$(expr $steps + $POCITERATIONS)
        fi
    done

    StepPRC=$(echo "scale=3; ($MaxPRC - $MinPRC) / $steps"  | bc)
    PRC="$MinPRC"
}

print_stats() {
    echo "Some results:"
    echo ""
    echo "Baseline (without flipper)"
    echo "####################"
    FLIPPER="without FLIPPER"
    LOGDIR="data/experiments/NoFlipper"
    EVALDIR="data/results/NoFlipper"
    for i in "${!BASELINE@}"; do
        if [ "${!i}" == "Y" ]; then
            print_$(getPoCNameFromConfig $i)
        fi
    done
    echo ""
    echo "Flipper"
    echo "####################"
    FLIPPER="with FLIPPER"
    LOGDIR="data/experiments/Flipper"
    EVALDIR="data/results/NoFlipper"
    for i in "${!FLIPPER@}"; do
        if [ "${!i}" == "Y" ]; then
            print_$(getPoCNameFromConfig $i)
        fi
    done
    echo ""
}

eval_init

EXECMODE="Evaluating"

FLIPPER="without FLIPPER"
LOGDIR="data/experiments/NoFlipper"
EVALDIR="data/results/NoFlipper"
mkdir $EVALDIR
for i in "${!BASELINE@}"; do
    if [ "${!i}" == "Y" ]; then
        setvar_$(getPoCNameFromConfig $i)
        Set_Step
        eval_$(getPoCNameFromConfig $i)
    fi
done

FLIPPER="with FLIPPER"
LOGDIR="data/experiments/Flipper"
EVALDIR="data/results/Flipper"
mkdir $EVALDIR
for i in "${!FLIPPER@}"; do
    if [ "${!i}" == "Y" ]; then
        setvar_$(getPoCNameFromConfig $i)
        Set_Step
        eval_$(getPoCNameFromConfig $i)
    fi
done

print_stats | tee data/summary.txt
