#!/bin/sh

setvar_TRRespassFuzzing() {
    POCNAME="TRRespass (Fuzzing)"
    POCITERATIONS=1
}

init_TRRespassFuzzing() {
    if [ "$BUILT_TRRespass" != "Y" ]; then
        trrespass=$(./PoC/hammertool/hammertool --importConfig $CONFIGDIR/addrFunctions.cnf | grep "TRRespass" | cut -d " " -f 2-)
        sed "s/\/\/{{TRRData}}/$trrespass/" PoC/trrespass/src/main_orig > PoC/trrespass/src/main.c
        cd PoC/trrespass && make; cd ../..
        export BUILT_TRRespass="Y"
    fi
    if [ "$BUILT_HugePage" != "Y" ]; then
        sh ./PoC/trrespass/hugepage.sh
        export BUILT_HugePage="Y"
    fi
}

measure_TRRespassFuzzing() {
    (time timeout -s SIGINT $TIMEOUT ./PoC/trrespass/obj/tester -r 1000000 --fuzzing -o TRRespassFuzzing_memprofile) 2>&1 | tee $LOGDIR/TRRespassFuzzing.log
    mv PoC/trrespass/data/TRRespassFuzzing_memprofile* $LOGDIR/
}

eval_TRRespassFuzzing() {
    cat $LOGDIR/TRRespassFuzzing.log | grep FLIP | wc -l > $EVALDIR/TRRespassFuzzing.txt
}

print_TRRespassFuzzing() {
    echo "TRRespassFuzzing:                           $(cat $EVALDIR/TRRespassFuzzing.txt)"
}
