#!/bin/sh

setvar_TRRespassDoubleSide() {
    POCNAME="TRRespass (Double Side)"
    POCITERATIONS=1
}

init_TRRespassDoubleSide() {
    if [ "$BUILT_TRRespass" != "Y" ]; then
        trrespass=$(./PoC/hammertool/hammertool --importConfig $CONFIGDIR/addrFunctions.cnf | grep "TRRespass" | cut -d " " -f 2-)
        sed "s/\/\/{{TRRData}}/$trrespass/" PoC/trrespass/src/main_orig > PoC/trrespass/src/main.c
        cd PoC/trrespass && make; cd ../..
        export BUILT_TRRespass="Y"
    fi
    if [ "$BUILT_HugePage" != "Y" ]; then
        sh ./PoC/trrespass/hugepage.sh
        export BUILT_HugePage="Y"
    fi
}

measure_TRRespassDoubleSide() {
    (time timeout -s SIGINT $TIMEOUT ./PoC/trrespass/obj/tester -r 1000000 -o TRRespassDoubleSide_memprofile) 2>&1 | tee $LOGDIR/TRRespassDoubleSide.log
    mv PoC/trrespass/data/TRRespassDoubleSide_memprofile* $LOGDIR/
}

eval_TRRespassDoubleSide() {
    cat $LOGDIR/TRRespassDoubleSide.log | grep FLIP | wc -l > $EVALDIR/TRRespassDoubleSide.txt
}

print_TRRespassDoubleSide() {
    echo "TRRespassDoubleSide:                        $(cat $EVALDIR/TRRespassDoubleSide.txt)"
}
