#!/bin/sh

setvar_RowhammerJS() {
    POCNAME="RowhammerJS"
    POCITERATIONS=1
}

init_RowhammerJS() {
    if [ "$BUILT_RowhammerJS" != "Y" ]; then
        rowhammerjs=$(./PoC/hammertool/hammertool --importConfig $CONFIGDIR/addrFunctions.cnf | grep "RowhammerJS" | cut -d " " -f 2-)
        sed "s/\/\/{{RowhammerJs}}/$rowhammerjs/" PoC/rowhammerjs/rowhammer_orig > PoC/rowhammerjs/rowhammer.cc
        cd PoC/rowhammerjs && make rowhammer-haswell; cd ../..
        export BUILT_RowhammerJS="Y"
    fi
}

measure_RowhammerJS() {
    (time timeout -s SIGALRM $TIMEOUT ./PoC/rowhammerjs/rowhammer-haswell -c $(nproc) -f 0 -d $DIMMS) 2>&1 | tee $LOGDIR/RowhammerJS.log
}

eval_RowhammerJS() {
    cat $LOGDIR/RowhammerJS.log | grep Found | wc -l > $EVALDIR/RowhammerJS.txt
}

print_RowhammerJS() {
    echo "RowhammerJS:                                $(cat $EVALDIR/RowhammerJS.txt)"
}
