#!/bin/sh

setvar_HammerToolnThreadsPin() {
    POCNAME="HammerTool (nThreads, with pinning, [Thread 1/$(nproc)])"
    POCITERATIONS=$(nproc)
}

init_HammerToolnThreadsPin() {
    if [ "$BUILT_HammerTool" != "Y" ]; then
        chmod +x ./PoC/hammertool/hammertool
        export BUILT_HammerTool="Y"
    fi
}

measure_HammerToolnThreadsPin() {
    totalmem=$(free -m | grep "Mem" | sed "s/^Mem:[ ]*\([0-9]*\).*/\1/")
    sets=$(expr \( $totalmem - 2048 \) / 2)
    if [ $sets -gt 512 ]; then
        sets=512
    fi

    (time timeout -s SIGINT $TIMEOUT ./PoC/hammertool/hammertool --hammerDoubleSide --sets $sets --importConfig $CONFIGDIR/addrFunctions.cnf --pinToCPU; echo $? > estat) 2>&1 | tee $LOGDIR/HammerToolnThreadsPin_1.log
    for threads in $(seq 2 $(nproc)); do
        POCNAME="HammerTool (nThreads, with pinning, [Thread $threads/$(nproc)])"
        Set_Step
        (time timeout -s SIGINT $TIMEOUT ./PoC/hammertool/hammertool --hammerDoubleSide --sets $sets --importConfig $CONFIGDIR/addrFunctions.cnf --multithreading=$threads --pinToCPU; echo $? > estat) 2>&1 | tee $LOGDIR/HammerToolnThreadsPin_$threads.log
    done
}

eval_HammerToolnThreadsPin() {
    for threads in $(seq 1 $nproc); do
        POCNAME="HammerTool (nThreads, with pinning, [Thread $threads/$(nproc)])"
        Set_Step
        cat $LOGDIR/HammerToolnThreadsPin_$threads.log | grep "Hammer found at offset" | wc -l > $EVALDIR/HammerToolnThreadsPin_$threads.txt
    done
}

print_HammerToolnThreadsPin() {
    for threads in $(seq 1 $nproc); do
        t=$(printf %02d $threads)
        echo "HammerTool ($t Threads, with pinning):      $(cat $EVALDIR/HammerToolnThreadsPin_$threads.txt)"
    done
}
