#!/bin/sh

setvar_HammerToolnThreadsNoPin() {
    POCNAME="HammerTool (nThreads, without pinning, [Thread 1/$(nproc)])"
    POCITERATIONS=$(nproc)
}

init_HammerToolnThreadsNoPin() {
    if [ "$BUILT_HammerTool" != "Y" ]; then
        chmod +x ./PoC/hammertool/hammertool
        export BUILT_HammerTool="Y"
    fi
}

measure_HammerToolnThreadsNoPin() {
    totalmem=$(free -m | grep "Mem" | sed "s/^Mem:[ ]*\([0-9]*\).*/\1/")
    sets=$(expr \( $totalmem - 2048 \) / 2)
    if [ $sets -gt 512 ]; then
        sets=512
    fi

    (time timeout -s SIGINT $TIMEOUT ./PoC/hammertool/hammertool --hammerDoubleSide --sets $sets --importConfig $CONFIGDIR/addrFunctions.cnf; echo $? > estat) 2>&1 | tee $LOGDIR/HammerToolnThreadsNoPin_1.log
    for threads in $(seq 2 $(nproc)); do
        POCNAME="HammerTool (nThreads, without pinning, [Thread $threads/$(nproc)])"
        Set_Step
        (time timeout -s SIGINT $TIMEOUT ./PoC/hammertool/hammertool --hammerDoubleSide --sets $sets --importConfig $CONFIGDIR/addrFunctions.cnf --multithreading=$threads; echo $? > estat) 2>&1 | tee $LOGDIR/HammerToolnThreadsNoPin_$threads.log
    done
}

eval_HammerToolnThreadsNoPin() {
    for threads in $(seq 1 $nproc); do
        POCNAME="HammerTool (nThreads, without pinning, [Thread $threads/$(nproc)])"
        Set_Step
        cat $LOGDIR/HammerToolnThreadsNoPin_$threads.log | grep "Hammer found at offset" | wc -l > $EVALDIR/HammerToolnThreadsNoPin_$threads.txt
    done
}

print_HammerToolnThreadsNoPin() {
    for threads in $(seq 1 $nproc); do
        t=$(printf %02d $threads)
        echo "HammerTool ($t Threads, without pinning):   $(cat $EVALDIR/HammerToolnThreadsNoPin_$threads.txt)"
    done
}
