#!/bin/sh

setvar_HammerTool() {
    POCNAME="HammerTool"
    POCITERATIONS=1
}

init_HammerTool() {
    if [ "$BUILT_HammerTool" != "Y" ]; then
        chmod +x ./PoC/hammertool/hammertool
        export BUILT_HammerTool="Y"
    fi
}

measure_HammerTool() {
    totalmem=$(free -m | grep "Mem" | sed "s/^Mem:[ ]*\([0-9]*\).*/\1/")
    sets=$(expr \( $totalmem - 2048 \) / 2)
    if [ $sets -gt 512 ]; then
        sets=512
    fi

    (time timeout -s SIGINT $TIMEOUT ./PoC/hammertool/hammertool --hammerDoubleSide --sets $sets --importConfig $CONFIGDIR/addrFunctions.cnf; echo $? > estat) 2>&1 | tee $LOGDIR/HammerTool.log
}

eval_HammerTool() {
    cat $LOGDIR/HammerTool.log | grep "Hammer found at offset" | wc -l > $EVALDIR/HammerTool.txt
}

print_HammerTool() {
    echo "HammerTool:                                 $(cat $EVALDIR/HammerTool.txt)"
}
