#!/bin/sh

setvar_HalfDoubleTRRespass() {
    POCNAME="HalfDouble (Assisted double aggressor rows as defined in the trrespass paper)"
    POCITERATIONS=1
}

init_HalfDoubleTRRespass() {
    if [ "$BUILT_HalfDoubleTRRespass" != "Y" ]; then
        chmod +x PoC/half_double/hammer
        export BUILT_HalfDoubleTRRespass="Y"
    fi
    if [ "$BUILT_HugePage" != "Y" ]; then
        sh ./PoC/trrespass/hugepage.sh
        export BUILT_HugePage="Y"
    fi
}

measure_HalfDoubleTRRespass() {
    (time timeout -s SIGINT $TIMEOUT ./PoC/half_double/hammer ./PoC/half_double/configTRRespass.cfg) 2>&1 | grep -v "Mapping function for 0x[0-9]* not respected" | tee $LOGDIR/HalfDoubleTRRespass.log
}

eval_HalfDoubleTRRespass() {
    echo "$(cat $LOGDIR/HalfDoubleTRRespass.log | grep '[0-9]* tries, [0-9]* flips, [0-9]* flips from repeats' | sed 's/[0-9]* tries, \([0-9]*\) flips, [0-9]* flips from repeats/\1/g' | tr '\n' '+' | sed 's/+$//g')" | bc > $EVALDIR/HalfDoubleTRRespass.txt
}

print_HalfDoubleTRRespass() {
    echo "HalfDoubleTRRespass:                        $(cat $EVALDIR/HalfDoubleTRRespass.txt)"
}
