#!/bin/sh

setvar_BlackSmith() {
    POCNAME="BlackSmith"
    POCITERATIONS=1
}

init_BlackSmith() {
    if [ "$BUILT_BlackSmith" != "Y" ]; then
        trrespass=$(./PoC/hammertool/hammertool --importConfig $CONFIGDIR/addrFunctions.cnf | grep "TRRespass" | cut -d " " -f 2-)
        counter=0
        channels=""
        dmidecode -t 17 | grep "^[^a-zA-Z0-9]*Size: " | while read line; do
            counter=$(expr $counter + 1)
            if [ "$(echo $line | grep -v 'No Module Installed')" == "" ]; then
                channel=$(dmidecode -t 17 | grep "^[^a-zA-Z0-9]*Locator: " | sed "${counter}q;d" | sed 's/.*-Channel\([A-Z]*\).*/\1/g')
                channels="$channels\n$channel"
            fi
        done
        
        num_channels=$(echo -e "$channels" | uniq | wc -l)
        num_dimms=$(dmidecode -t 17 | grep "^[^a-zA-Z0-9]*Size: " | grep -v "No Module Installed" | wc -l)
        num_ranks=$(echo "0 + $(dmidecode -t 17 | grep "^[^a-zA-Z0-9]*Rank: " | grep -v "Unknown" | sed 's/^[^0-9]*\([0-9]\).*/\1/g' | tr '\n' '+' | sed 's/+$//g')" | bc)
        num_banks=$(echo "2^$(echo "$trrespass" | sed 's/.*{{{[^}]*}, \([^}]*\)}.*/\1/g')" | bc)
        dram_fns=$(echo "$trrespass" | sed 's/.*{{{\([^}]*\)}.*/\1/g')
        row_fn=$(echo "$trrespass" | sed 's/.*{{{[^}]*},[^}]*}, \([^}]*\),.*/\1/g')
        col_fn=$(echo "$trrespass" | sed 's/.*{{{[^}]*},[^}]*},[^,]*, \([^}]*\).*/\1/g')

        sed -i "s/= .*{{num_channels}}/= $num_channels #{{num_channels}}/g" ./PoC/blacksmith/mat-gen.py
        sed -i "s/= .*{{num_dimms}}/= $num_dimms #{{num_dimms}}/g" ./PoC/blacksmith/mat-gen.py
        sed -i "s/= .*{{num_ranks}}/= $num_ranks #{{num_ranks}}/g" ./PoC/blacksmith/mat-gen.py
        sed -i "s/= .*{{num_banks}}/= $num_banks #{{num_banks}}/g" ./PoC/blacksmith/mat-gen.py
        sed -i "s/= .*{{dram_fns}}/= \[$dram_fns\] #{{dram_fns}}/g" ./PoC/blacksmith/mat-gen.py
        sed -i "s/= .*{{row_fn}}/= $row_fn #{{row_fn}}/g" ./PoC/blacksmith/mat-gen.py
        sed -i "s/= .*{{col_fn}}/= $col_fn #{{col_fn}}/g" ./PoC/blacksmith/mat-gen.py

        code=$(python ./PoC/blacksmith/mat-gen.py | tail -n +3 | sed -e 's/[^^]/&/g; s/\^/\\^/g; $!a\'$'\n''\\n' | tr -d '\n')
        sed -i "s/{{CODE}}/$code/g" ./PoC/blacksmith/src/Memory/DRAMAddr.cpp

        chmod +x ./PoC/blacksmith/measureTime
        ./PoC/blacksmith/measureTime -d | tee measureTime.log
        thresh=$(cat measureTime.log | tail -n 1)
        sed -i "s/#define THRESH .*{{THRESH}}/#define THRESH $thresh \/\/{{THRESH}}/g" ./PoC/blacksmith/include/GlobalDefines.hpp

        sed -i "s/#define NUM_BANKS .*{{NUM_BANKS}}/#define NUM_BANKS $num_banks \/\/{{NUM_BANKS}}/g" ./PoC/blacksmith/include/GlobalDefines.hpp

        mycpu=$(cat /proc/cpuinfo  | grep "model name" | head -n1 | cut -d " " -f 5)
        sed -i "s/{{CPU}}/$mycpu/g" ./PoC/blacksmith/src/Blacksmith.cpp

        cd ./PoC/blacksmith/build
        cmake ../
        make -j $(nproc)
        cd ../../../
        mv ./PoC/blacksmith/build/blacksmith ./PoC/blacksmith/
        chmod +x ./PoC/blacksmith/blacksmith
        export BUILT_BlackSmith="Y"
    fi
    if [ "$BUILT_HugePage" != "Y" ]; then
        sh ./PoC/trrespass/hugepage.sh
        export BUILT_HugePage="Y"
    fi
}

BlackSmith_watchdog() {
    sleep 120
    size=$(ls -l stdout.log | cut -d " " -f 5)
    if [ $size -eq 0 ]; then
        kill -9 $(pidof blacksmith)
    fi
}

measure_BlackSmith() {
    echo -n "" >  stdout.log
    tmux splitw -d -h tail -f stdout.log
    echo 1 > estat
    iter=0
    mins=0
    maxmins=20
    num_ranks=$(echo "0 + $(dmidecode -t 17 | grep "^[^a-zA-Z0-9]*Rank: " | grep -v "Unknown" | sed 's/^[^0-9]*\([0-9]\).*/\1/g' | tr '\n' '+' | sed 's/+$//g')" | bc)
    while [ "$(cat estat)" != "0" ] && [ $mins -lt $maxmins ]; do
        # Rebuild and re-calculate threshold (the previous measurement might be
        # the problem).
        export BUILT_BlackSmith="N"
        init_BlackSmith

        echo -n "" >  stdout.log
        iter=$(expr $iter + 1)
        echo "Starting BlackSmith PoC (try $iter/$maxrun)"
        BlackSmith_watchdog &
        watchdogPid=$!
        orig_preload=$LD_PRELOAD
        export LD_PRELOAD="./PoC/blacksmith/libasmjit.so"
        (time timeout -s SIGINT $TIMEOUT ./PoC/blacksmith/blacksmith --dimm-id 1 --ranks $num_ranks --runtime-limit $TIMEOUT_SEC; echo $? > estat) 2>&1 | tee $LOGDIR/BlackSmith.log
        export LD_PRELOAD=$orig_preload
        kill -9 $watchdogPid
        mins=$(cat $LOGDIR/BlackSmith.log | tail -n 3 | grep real | sed 's/real[^0-9]*\([0-9]*\)m.*/\1/g')
    done
    tmux kill-pane -t 1
    mv fuzz-summary.json $LOGDIR/BlackSmith_summary.json 2>/dev/null
    mv stdout.log $LOGDIR/BlackSmith_stdout.log 2>/dev/null
}

eval_BlackSmith() {
    echo "$(cat $LOGDIR/BlackSmith_stdout.log | grep '\[!\] Flip ' | wc -l)" > $EVALDIR/BlackSmith.txt
}

print_BlackSmith() {
    echo "BlackSmith:                                 $(cat $EVALDIR/BlackSmith.txt)"
}
