#include "memcp.h"

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<string.h>
#include<sys/types.h>
#include<sys/mman.h>
#include<dirent.h>
#include<signal.h>

#include "filelist.h"
#include "fileread.h"

void printHelp(const char *binary, int exitCode) {
  printf("Usage: %s [basePath] [targetPath]\n", binary);

  exit(exitCode);
}

void removeTrailingSlashes(char *str) {
  while(str[strlen(str)-1] == '/') {
    str[strlen(str)-1] = 0;
  }
}

int main(int argc, char *argv[]) {
  if(argc < 3) {
    printHelp(argv[0], EXIT_FAILURE);
  }

  char *basePath = argv[1];
  char *targetPath = argv[2];

  removeTrailingSlashes(basePath);
  removeTrailingSlashes(targetPath);

  size_t nFiles = 0;
  size_t nBytes = 0;
  char **fileList = getFileList(basePath, &nFiles, &nBytes, 1);

  for(u_int64_t i = 0; i < nFiles; i++) {
    nBytes += strlen(fileList[i]);
  }

  size_t hugePageSize = 512 * sysconf(_SC_PAGESIZE);
  size_t targetSize = ((nBytes * 2) / hugePageSize + 1) * hugePageSize;

  char *buf = allocateBuffer(targetSize);

  // Wait for snapshot signal
  sigset_t sigset;
  sigemptyset(&sigset);
  sigaddset(&sigset, SIGUSR1);
  sigprocmask(SIG_BLOCK, &sigset, NULL);
  int signal;

  printf("Initialization done. Send SIGUSR1 to my PID %d to create an in-memory snapshot.\n", getpid());
  sigwait(&sigset, &signal);

  readFilesToBuffer(buf, targetSize, fileList, nFiles);

  // Wait for persistence signal
  printf("In-memory snapshot done. Send SIGUSR1 to my PID %d to copy the data to the submitted target directory.\n", getpid());
  sigwait(&sigset, &signal);

  persistBuffer(buf, targetPath, basePath);

  // Cleanup
  freeFileList(&fileList, &nFiles);
  munmap(buf, targetSize);

  return EXIT_SUCCESS;
}
