#!/bin/sh

iterations=100
nFreePages=4096
cnt=0
sum=0

while [ $cnt -lt $iterations ]; do
  nRealloc=$(sh measureRemap.sh  | cut -d " " -f 3 | cut -d "/" -f 1)
  if [ "$nRealloc" == "" ]; then
    nRealloc=0
  fi
  sum=$(expr $sum + $nRealloc)
  cnt=$(expr $cnt + 1)
done

avg=$(echo "scale=2;$sum/$iterations" | bc)
avgPerc=$(echo "scale=2;100 * $avg/$nFreePages" | bc)

printf "Average page reallocations after %d iterations: %4.2f (%3.2f%%)" $iterations $avg $avgPerc
