#!/bin/sh
#
# measureRemap.sh executes the measureRemap and allocates 32728 pages in the
# parent and in the child process. Before executing the child, 4096 pages are
# freed from the parent in a random order (to avoid the buddy allocator merging
# them). Afterwards, the child is executed.
#
# Next, it is evaluated how any of the parent mapping pages (e.g. of the 32728
# pages allocated) are mapped somewhere within the child process (any mapping,
# not only the 32728 child pages). Then, the remapping percentage (of the 4096
# pages freed in the parent) is calculated.

nFreePages=4096
sudo ./bin/measureRemap -n 32728 -f $nFreePages -m 32728 >/dev/null 2>&1
sudo chmod 644 parent.log
sudo chmod 644 child.log
sudo chmod 644 parent_mapping.log
sudo chmod 644 child_mapping.log

cat parent_mapping.log | grep "^0x[0-9a-f]*" | sort > parent.tmp
cat child.log | grep "^0x[0-9a-f]*" | sort > child.tmp

remapped=$(comm --total parent.tmp child.tmp | tail -n 1 | sed 's/^[0-9]*[^0-9]*[0-9]*[^0-9]*\([0-9]*\).*/\1/g')

perc=$(echo "scale=2;100 * $remapped/$nFreePages" | bc)

printf "Remapped %5d/%5d pages (%3.2f%%)\n" $remapped $nFreePages $perc

rm parent.tmp
rm child.tmp
rm -f parent.log
rm -f child.log
rm -f parent_mapping.log
rm -f child_mapping.log
