#include<linux/init.h>
#include<linux/module.h>
#include<linux/proc_fs.h>
#include<linux/slab.h>
#include<linux/kvm_host.h>

#include "measurePageSize.h"

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Martin Heckel");
MODULE_DESCRIPTION("Dump page size information");
MODULE_VERSION("1.0");

/*******************************************************************************
 * measurePageSizeInit is called when the kernel module is loaded. It writes the
 * following information based on the current system configuration to the kernel
 * log:
 *  - PAGE_SHIFT (offset between end of virtual address and begin of in-page
 *    part of the virtual address)
 *  - PMD_SHIFT (offset between end of virtual address and begin of PMD part
 *    of the virtual address)
 *  - PUD_SHIFT (offset between end of virtual address and begin of PUD part
 *    of the virtual address)
 *  - PGDIR_SHIFT (offset between end of virtual address and begin of PGDIR part
 *    of the virtual address)
 *  - BITS_PER_LONG (length of a virtual address)
 ******************************************************************************/
static int __init measurePageSizeInit(void) {
  printk(KERN_INFO "[measurePageSize]: Loaded");
  printk(KERN_INFO "PAGE_SHIFT: %ld", PAGE_SHIFT);
  printk(KERN_INFO "PMD_SHIFT: %ld", PMD_SHIFT);
  printk(KERN_INFO "PUD_SHIFT: %ld", PUD_SHIFT);
  printk(KERN_INFO "PGDIR_SHIFT: %ld", PGDIR_SHIFT);
  printk(KERN_INFO "BITS_PER_LONG: %ld", BITS_PER_LONG);
  return 0;
}

/*******************************************************************************
 * measurePageSizeExit is called when the kernel module is unloaded.
 ******************************************************************************/
static void __exit measurePageSizeExit(void) {
  printk(KERN_INFO "[measurePageSize]: Unloaded");
}

module_init(measurePageSizeInit);
module_exit(measurePageSizeExit);
