#!/bin/sh
#
# measureRemap.sh executes the measureRemap and allocates 32728 pages in the
# parent and in the child process. Before executing the child, 4096 pages are
# freed from the parent in a random order (to avoid the buddy allocator merging
# them). Afterwards, the child is executed.
#
# Next, it is evaluated how any of the parent mapping pages (e.g. of the 32728
# pages allocated) are mapped somewhere within the child process (any mapping,
# not only the 32728 child pages). Then, the remapping percentage (of the 4096
# pages freed in the parent) is calculated.

nFreePages=4096
sudo ./bin/measureRemap -n 32728 -f $nFreePages -m 32728 >/dev/null 2>&1
sudo chmod 644 parent.log
sudo chmod 644 child.log
sudo chmod 644 parent_mapping.log
sudo chmod 644 child_mapping.log

mkdir data/$1/
./bin/evaluate -c child_mapping.log -p parent_mapping.log -e data/$1

rm -f parent.log
rm -f child.log
rm -f parent_mapping.log
rm -f child_mapping.log
