#ifndef EVALUATE_ALL_H
#define EVALUATE_ALL_H

typedef struct {
  u_int64_t parentOffset;
  u_int64_t *childOffsets;
  u_int64_t nChildOffsets;
  double average;
  double variance;
  double standardDeviation;
} result;

typedef struct {
  result **res;
  u_int64_t nRes;
} results;

result *constructResult(u_int64_t parentOffset);
result *addChildOffsetToResult(result *res, u_int64_t childOffset);
result *calculateResultStats(result *res);

results *constructResults();
results *addResultToResults(results *res, result *r);
results *handleLine(results *res, char *line);
results *handleFile(results *res, char *path);
results *calculateResultsStats(results *res);
void storeResults(results *res, char *path, u_int64_t stepWidth);

#endif
