#ifndef EVALUATE_H
#define EVALUATE_H

typedef struct {
  u_int64_t *pfns;
  u_int64_t nPfns;
} pfnList;

typedef struct {
  pfnList *pfns;
  char *name;
} mapSection;

typedef struct {
  mapSection **sections;
  u_int64_t nSections;
} mapSections;

u_int64_t parseHex(char *str);
pfnList *getPfnList(char **pfns, u_int64_t nPfns);
mapSection *getMapSection(pfnList *pfns, char *sectionName);
mapSections *constructMapSections();
mapSections *addToMapSections(mapSections *sections, mapSection *section);
mapSections *parseMapFile(char *mapFile);

char *getSectionAndOffset(mapSections *sections, u_int64_t searchPfn, u_int64_t *offset);

#endif
