#!/bin/sh
# For some strange reason, kill -s 2 does not work when run with "sh" in a new
# Process. Use "source $0" instead in order to successfully execute the script.

if [ ! -d /proc/allocTrace ]; then
  echo "Please load allocTrace.ko before executing this script."
  return
fi

timeout=10
nFreePages=32728

sudo rm -rf data/*

# Initialize memcp stage 1
mkdir -p data/allocTraceBefore
../MemCP/bin/memcp /proc/allocTrace/ data/allocTraceBefore/ &
beforepid=$!
sleep 0.1

mkdir -p data/allocTraceBetween
../MemCP/bin/memcp /proc/allocTrace/ data/allocTraceBetween/ &
betweenpid=$!
sleep 0.1

mkdir -p data/allocTraceAfter
../MemCP/bin/memcp /proc/allocTrace/ data/allocTraceAfter/ &
afterpid=$!
sleep 0.1

# Start trace
#rm -f trace*.dat
#taskset 0x02 sudo trace-cmd record -e kmem/mm_page_alloc -e kmem/mm_page_free --cmdlines-size 32728 -b 102400 -M 0x04&
#tracepid=$!

# Wait some time (see above)
#sleep $timeout

# Create "before" snapshot from buddy allocator
sleep 0.05
kill -s SIGUSR1 $beforepid
sleep 0.05

# Execute binary
taskset 0x01 sudo ./bin/measureRemap -n 32728 -f $nFreePages -m 32728 -p $betweenpid -c $afterpid >/dev/null 2>&1

# Create  "after" snapshot from buddy allocator
#sleep 0.05
#kill -s SIGUSR1 $afterpid
#sleep 0.05

# Wait some time (see above)
#sleep $timeout

# Stop trace
#kill -s 2 $tracepid
#sleep 5

# Post processing
#trace-cmd report trace.dat > trace.log

kill -s SIGUSR1 $beforepid
kill -s SIGUSR1 $betweenpid
kill -s SIGUSR1 $afterpid

sudo chmod 644 parent.log
sudo chmod 644 child.log
sudo chmod 644 parent_mapping.log
sudo chmod 644 child_mapping.log

sleep 0.1

# Evaluation
./bin/evaluate -t none -p parent_mapping.log -c child_mapping.log > result.log
./bin/evaluate -t none -p child_mapping.log -c parent_mapping.log >> result.log
python evaluate.py
mkdir -p plots
rm plots/*
python genData.py

#rm -f parent.log
#rm -f child.log
#rm -f parent_mapping.log
#rm -f child_mapping.log
