#!/usr/bin/env python3

import os
import sys
import shutil
import subprocess

def generate_plotfile(dirname):
    #shutil.copyfile('graph.gpl', filename)
    graphname = dirname.rsplit('/', 1)[1]
    print("Graphname: " + graphname)
    for mode in ["before", "between", "after"]:
        if not os.path.isdir(dirname + "/" + mode):
            continue
        os.system("cat graph.gpl | sed 's/##MODE##/" + mode + "/g;s/##SECTION##/" + graphname + "/g' > tmp.gpl")
        with open("tmp.gpl", 'a') as file:
            file.write("plot ")
            file_list = os.listdir(dirname + "/" + mode)
            file_list.sort()
            for f in file_list:
                filename = os.path.join(dirname + "/" + mode, f)
                if not os.path.isfile(filename):
                    continue

                file.write("'" + filename + "' using 1:2 w lp,\\\n")
        os.system("gnuplot tmp.gpl")
        os.system("mv plot.svg plots/" + graphname + "_" + mode + ".svg")

for f in os.listdir("data_tmp"):
    filename = os.path.join("data_tmp", f)
    if not os.path.isdir(filename):
        continue

    generate_plotfile(filename)
