#!/bin/sh

file="result.log"

lastSourceSection=""
lastBuddyBeforeOrder=""

lastLine=""
buddyBefore=""
buddyAfter=""

handleLines() {
  if [ "$lastLine" == "" ] || [ "$buddyBefore" == "" ]; then
    return
  fi

  sourceSection=$(echo $lastLine | cut -d " " -f 7)
  sourceSection=$(echo $sourceSection | sed "s/\[//g;s/\]//g;s/\///g;s/<//g;s/>//g;s/'//g")

  sourceOffset=$(echo $lastLine | cut -d " " -f 11)

  buddyBeforeOrder=$(echo $buddyBefore | cut -d " " -f 5 | cut -d "/" -f 5)
  buddyBeforeOffset=$(echo $buddyBefore | cut -d " " -f 8)

  buddyAfterOrder=$(echo $buddyAfter | cut -d " " -f 5 | cut -d "/" -f 5)
  buddyAfterOffset=$(echo $buddyAfter | cut -d " " -f 8)

  mkdir data_tmp/$sourceSection 2>/dev/null
  mkdir data_tmp/$sourceSection/before 2>/dev/null
  mkdir data_tmp/$sourceSection/after 2>/dev/null
  echo "$sourceOffset $buddyBeforeOffset" >> data_tmp/$sourceSection/before/$buddyBeforeOrder.dat
  echo "$sourceOffset $buddyAfterOffset" >> data_tmp/$sourceSection/after/$buddyAfterOrder.dat
}

rm -r data_tmp 2>/dev/null
mkdir data_tmp

nLines=$(cat $file | grep '^PFN 0x\|Buddy matches before\|Buddy matches after' | grep -v '? ->' | tee tmp.txt | wc -l)

currentLine=0
while read -r line; do
  currentLine=$(expr $currentLine + 1)
  perc=$(echo "scale=2;100 * $currentLine / $nLines" | bc)
  echo -ne "\r$(printf %.2f $perc)%"
  if [ "$(echo $line | grep '^PFN 0x')" != "" ]; then
    handleLines
    lastLine=$line
    buddyBefore=""
    buddyAfter=""
  fi
  if [ "$(echo $line | grep '^Buddy matches before')" != "" ]; then
    buddyBefore=$line
  fi
  if [ "$(echo $line | grep '^Buddy matches after')" != "" ]; then
    buddyAfter=$line
  fi
done < tmp.txt

rm tmp.txt
