#!/usr/bin/env python

import os

def read_file(path):
    content = ""
    with open(path, 'rt') as file:
        content = file.read()

    return content

def handle_file(content):
    last_section = ""
    buddy_before = ""
    buddy_between = ""
    buddy_after = ""
    n_lines = len(content.split("\n"))

    n_line = 0
    for line in content.split("\n"):
        n_line += 1
        perc = 10000 * n_line // n_lines
        print("\r" + str(perc // 100) + "." + str(perc % 100) + "%", end="")
        if line.startswith("PFN 0x"):
            handle_lines(last_section, buddy_before, buddy_between, buddy_after)
            last_section = line
            buddy_before = ""
            buddy_between = ""
            buddy_after = ""

        if line.startswith("\tBuddy matches before"):
            buddy_before = line

        if line.startswith("\tBuddy matches between"):
            buddy_between = line

        if line.startswith("\tBuddy matches after"):
            buddy_after = line

    print("")

def handle_lines(last_section, buddy_before, buddy_between, buddy_after):
    if last_section == "":
        return

    if buddy_before == "" and buddy_after == "" and buddy_between == "":
        return

    source_section = last_section.split("(")[1].split(" ")[1].replace("'", "").replace("[", "").replace("]", "").replace("<", "").replace(">", "").replace("/", "")
    source_offset = last_section.split(")")[1].split(" ")[2]

    if buddy_before != "":
        handle_buddy_line(source_section, source_offset, buddy_before, "before")

    if buddy_between != "":
        handle_buddy_line(source_section, source_offset, buddy_between, "between")

    if buddy_after != "":
        handle_buddy_line(source_section, source_offset, buddy_after, "after")

def handle_buddy_line(source_section, source_offset, buddy_line, path_string):
    buddy_type = buddy_line.split(" ")[4].split("/")[4]
    buddy_order = buddy_line.split(" ")[4].split("/")[5]
    buddy_offset = buddy_line.split(" ")[7]
    path = "data_tmp/" + source_section + "/" + path_string
    if not os.path.isdir(path):
        if not os.path.isdir("data_tmp/" + source_section):
            os.mkdir("data_tmp/" + source_section)
        os.mkdir("data_tmp/" + source_section + "/" + path_string)

    with open("data_tmp/" + source_section + "/" + path_string + "/" + buddy_type + "_" + buddy_order + ".dat", "at") as file:
        file.write(source_offset + " " + buddy_offset + "\n")

os.system("rm -r data_tmp 2>/dev/null")
os.system("mkdir data_tmp 2>/dev/null")
handle_file(read_file("result.log"))
