#ifndef HYBRID_GROUP_HELPER_H
#define HYBRID_GROUP_HELPER_H

#include<stdlib.h>
#include "memlib/memoryInspect.h"

#define N_PAGES_FOR_THP 512
#define K (1<<10)
#define M (1<<20)
#define G (1<<30)

typedef u_int64_t flag_t;

#define FL_NONE 0
#define FL_DEBUG 1
#define FL_NOCACHE 2

typedef struct {
    volatile char **addresses;
    u_int64_t *addressSizes;
    u_int64_t nAddresses;
} addressGroup;

typedef struct {
    addressGroup ** addressGroups;
    u_int64_t nAddressGroups;
} addressGroups;

int compareInt(const void *v1, const void *v2);
u_int64_t *shuffleUInt64Array(u_int64_t *arr, u_int64_t len);
addressGroup *getHugepages(u_int64_t nPages);
u_int64_t getPageSize();
addressGroup *initializeAddressGroup();
addressGroup *freeAddressGroup(addressGroup *aGroup, u_int64_t recursive);
addressGroup *addAddressToAddressGroup(addressGroup *aGroup, volatile char *address, u_int64_t addressSize);
addressGroup *removeAddressFromAddressGroup(addressGroup *aGroup, u_int64_t index, u_int64_t freeAddress);
addressGroup *removeAddressFromAddressGroupWithoutRelocate(addressGroup *aGroup, u_int64_t index, u_int64_t freeAddress);
addressGroup *cleanAddressGroup(addressGroup *aGroup);
void prntAddressGroup(addressGroup *aGroup);
u_int64_t countAddressesInAddressGroup(addressGroup *aGroup);
addressGroups *initializeAddressGroups();
addressGroups *freeAddressGroups(addressGroups *aGroups, u_int64_t recursive, u_int64_t freeSingleAddresses);
addressGroups *addAddressGroupToAddressGroups(addressGroups *aGroups, addressGroup *aGroup);
addressGroups *removeAddressGroupFromAddressGroups(addressGroups *aGroups, u_int64_t index, u_int64_t cleanupAddressGroups, u_int64_t cleanupAddress);
addressGroups *removeAddressGroupFromAddressGroupsWithoutRelocate(addressGroups *aGroups, u_int64_t index, u_int64_t cleanupAddressGroups, u_int64_t cleanupAddress);
addressGroups *cleanAddressGroups(addressGroups *aGroups);
void printAddressGroups(addressGroups *aGroups);
u_int64_t countAddressesInAddressGroups(addressGroups *aGroups);
u_int64_t parseNumber(const char *number);
void printMappingsAndTime(addrInfo **aInfo, u_int64_t *timings, u_int64_t len);
void printMappings(addrInfo **aInfo, u_int64_t len, u_int64_t debug);
void dumpPage(void *page);
addrInfo **updatePhysicalInformation(addrInfo **aInfo, u_int64_t len);
u_int64_t *addToArray(u_int64_t *arr, u_int64_t *size, u_int64_t val);
int64_t findValue(u_int64_t *arr, u_int64_t size, u_int64_t val);
u_int64_t *uniqueAddToArray(u_int64_t *arr, u_int64_t *size, u_int64_t val);
//char *readFile(char *filepath);

#endif
