#ifndef HLIB_AFUNC_H
#define HLIB_AFUNC_H

#include "../memlib/memoryInspect.h"
#include "util.h"

#define N_PAGES_FOR_THP 512

typedef struct {
    int id;
    int start;
    int end;
    long *masks;
    hlAddressGroups *aGroups;
    long expectedMisses;
    long maskBits;
    int minimumHitRatio;
    int verbosity;
    hlMaskItems *mItems;
    pthread_mutex_t *mutex;
} hlMaskThreadItem;

int hlAddPageToGroups(addrInfo *page, int threshold, int iter, hlAddressGroups *aGroups, int nCheck, int getTime, int fenced);
volatile char *hlGetHugepages(int nPages, hlAddrInfos *aInfos, int vMode, int skip, int verbosity);
int hlAddHugepagesToGroups(int nHugepage, hlAddressGroups *aGroups, hlMaskItems *mItems, int vMode, int blockSize, volatile char ***addrs, int *len, int verbosity);
int hlGetThreshold(int banks, hlAddrInfos *aInfos, int (*measureAccessTime)(volatile char *, volatile char *, int, int), int iter, int *accessTimeCnt, int verbosity, int scale, int skip, int fenced);
int hlAddVirtualHugepagesToGroups(int nHugepage, hlAddressGroups *aGroups, hlMaskItems *mItems, int hugepageId, int getTime, int iter, int *accessTimeCnt, int verbose, int nChecks, int scale);
int hlScanHugepages(int nHugepage, hlAddressGroups *aGroups, int verbosity, int banks, int nChecks, int iter, int *accessTimeCnt, int getTime, int vMode, int hugepageOffset, int scale, int skip, int measureChunkSize, int fenced);
int hlUnifyAddressGroups(hlAddressGroups *aGroups, int threshold, int iter, int nChecks, int getTime, int fenced);
int hlSortAddressGroups(hlAddressGroups *aGroups, hlMaskItems *mItems, int verbosity);
void hlFindMasks(hlAddressGroups *aGroups, int nBits, hlMaskItems *mItems, int verbose);
void hlFindVirtualMasks(hlAddressGroups *aGroups, int nBits, hlMaskItems *mItems, int verbose);
int hlGetBankNumber(int iterations, int nChecks, int errtres, int iter, int *accessTimeCnt, int verbose, int getTime, int vMode, int scale, int fenced);
int hlGetEffectiveChunkSize(volatile char *p1, int getTime, int iter, int verbose, int fenced);

#endif
