# HammerLib

## About
HammerLib is a userspace library that provides interfaces for easy and uniform rowhammer exploitation. The provided interfaces can be used for all-in-one rowhammer exploitation: The can measure some metrics of the system, reverse-engineer the address functions of the banks and execute the actual rowhammer attack.

## Build
Because HammerLib is just a library, it cannot be built directly but has to be included in other projects.

## Usage
See the directory **examples** for usage examples of HammerLib. See **HammerTool** for another example.

## Structure of this directory
* **afunc.c**: File containing the implementation of the reverse-engineering of the address function of the banks.
* **afunc.h**: File containing the headers of the reverse-engineering of the address function of the banks and the definition of related data structures.
* **asm.h**: File containing the implementation of assembler instruction as C functions (using inline assembler).
* **afunc.c**: File containing the implementation of the rowhammer attack.
* **afunc.h**: File containing the headers of the reverse-engineering of the rowhammer attack and the definition of related data structures.
* **util.c**: File containing the implementation of utility functions.
* **util.h**: File containing the headers of utility functions and the definition of related data structures.
* **examples**: Directory containing some examples how to use MemLib
* **README.md** README file with some documentation
