#ifndef HYBRID_GROUP_GROUP_H
#define HYBRID_GROUP_GROUP_H

#include "memlib/memoryInspect.h"
#include "helper.h"

u_int64_t *getRandomIndices(u_int64_t len, u_int64_t maxGroupComparisons);
u_int64_t timeAddressToGroup(addressGroup *aGroup, u_int64_t maxGroupComparisons, volatile char *addr, u_int64_t measurementsPerAddress);
int64_t getGroupIdxForAddress(addressGroups *aGroups, u_int64_t maxGroupComparisons, u_int64_t threshold, volatile char *addr, u_int64_t measurementsPerAddress, flag_t flags, int mustGroup);
addressGroups *removeSmallGroups(addressGroups *aGroups, u_int64_t fractionOfMedian, u_int64_t freeAddressesInRemovedGroups);
addressGroups *groupAddresses(addrInfo ** aInfo, u_int64_t len, u_int64_t threshold, u_int64_t maxGroupComparisons, u_int64_t measurementsPerAddress, flag_t flags);
addressGroups *regroupAddresses(addressGroups *aGroups, u_int64_t threshold, u_int64_t maxGroupComparisons, u_int64_t measurementsPerAddress, flag_t flags);
void verifyGroups(addressGroups *aGroups, u_int64_t threshold, u_int64_t maxGroupComparisons);

#endif
