#ifndef HYBRID_GROUP_BANK_SEQUENCE_H
#define HYBRID_GROUP_BANK_SEQUENCE_H

static inline u_int64_t xorBits(u_int64_t x) {
    int sum = 0;
    while(x != 0) {
        //x&-x has a binary one where the lest significant one
        //in x was before. By applying XOR to this, the last
        //one becomes a zero.
        //
        //So, this overwrites all ones in x and toggles sum
        //every time until there are no ones left.
        //
        //This looks a bit strange but increases speed. Because
        //this is called very often (once for each mask and each
        //pfn), it should be done this way. Maybe, there is also
        //an even better way.
        sum^=1;
        x ^= (x&-x);
    }
    return sum;
}

static inline u_int64_t countBits(u_int64_t x) {
    int sum = 0;
    while(x != 0) {
        sum++;
        x ^= (x&-x);
    }
    return sum;
}

typedef struct {
    u_int64_t *offsets;
    u_int64_t nOffsets;
    u_int64_t verificationOffset;
    u_int64_t sequenceLength;
} uniqueBankOffset;

typedef struct {
    u_int64_t *bankSequence;
    u_int64_t nBankSequence;
    uniqueBankOffset **uniqueBankOffsets;
    u_int64_t nUniqueBankOffsets;
    u_int64_t *bankToGroupMapping;
    u_int64_t *groupToBankMapping;
    u_int64_t nBanks;
} bankInformation;

void dumpUniqueBankOffsets(uniqueBankOffset *bOffset);
u_int64_t calculateBankFromAddress(volatile char *address, u_int64_t *fns, u_int64_t nFns);
uniqueBankOffset *getBankOffsetForBlockSize(bankInformation *bInfo, u_int64_t blockSize);
u_int64_t verifyBankSequence(bankInformation *bInfo, u_int64_t *banks, u_int64_t nBanks, u_int64_t verificationBank, u_int64_t blockSize, u_int64_t **partSequence, flag_t flags);
bankInformation *getBankInformation(u_int64_t *fns, u_int64_t nFns, flag_t flags);
bankInformation *addBankMappingInformation(bankInformation *bInfo, u_int64_t *fns, u_int64_t nFns, addressGroups *aGroups, u_int64_t threshold, u_int64_t maxGroupComparisons, u_int64_t nHugePages, u_int64_t measurementsPerAddress);
bankInformation *freeBankInformation(bankInformation *bInfo);

#endif
