#ifndef HYBRID_GROUP_ASM_H
#define HYBRID_GROUP_ASM_H

//#define DDR4

static inline void clflushopt(volatile void *addr) {
    #ifdef DDR4
    asm volatile("clflushopt (%0)" : : "r" (addr) : "memory");
    #else
    asm volatile("clflush (%0)" : : "r" (addr) : "memory");
    #endif
}

static inline void clflush(volatile void *addr) {
    asm volatile("clflush (%0)" : : "r" (addr) : "memory");
}

static inline void mfence() {
    asm volatile("mfence" : : : "memory");
}

static inline void lfence() {
    asm volatile("lfence" : : : "memory");
}

static inline void sfence() {
    asm volatile("sfence" : : : "memory");
}

static inline int64_t rdtscp() {
    int64_t a, c, d;
    asm volatile("rdtscp" : "=a"(a), "=d"(d), "=c"(c) : : );
    return (d<<32)|a;
}

static inline void cpuid() {
    asm volatile("cpuid" : : : "memory");
}

#endif
