#ifndef ALLOC_TRACE_H
#define ALLOC_TRACE_H

typedef struct {
  off_t offset;
  int openCount;
  struct proc_dir_entry *parent;
  struct proc_dir_entry *proc;
  struct zone *zone;
  int order;
  int migrateType;
  int pcpList;
} allocTraceFileInfo;

static int __init allocTraceInit(void);
static void __exit allocTraceExit(void);

struct zone **getZones(int *nZones);
int initProcFsDirs(void);
int clearProcFsDirs(void);

static ssize_t allocTraceRead(struct file *f, char *buf, size_t size, loff_t *offset);
static ssize_t allocTraceWrite(struct file *f, const char *buf, size_t size, loff_t *offset);
static loff_t allocTraceLseek(struct file *f, loff_t offset, int whence);
static int allocTraceOpen(struct inode *ino, struct file *f);
static int allocTraceRelease(struct inode *ino, struct file *f);

#endif
